# exemple-auth

## À faire

- Se familiariser avec les requêtes qui sont dans le fichier `requests.http`.
- Exécuter le projet et voir le résultat dans le navigateur en observant le comportement associé aux actions tout en essayant de comprendre le code. Login : test@test.com / Mot de passe : test

### Utilisateur non connecté

À partir de la page connexion...
| Action                                                                        | Comportement                                          |
| ----------------------------------------------------------------------------- | ----------------------------------------------------- |
| Accéder à la page profile (/profile) via l'URL                                | L'utilisateur est redirigé vers la page de connexion. |
| Ne saisir aucune information et cliquer sur le bouton "Connexion".            | D'où provient le message d'erreur ?                      |
| Saisir un courriel valide et un mot de passe avec un seul caractère.          | D'où provient le message d'erreur ?                      |
| Saisir un courriel valide et un mauvais mot de passe de plus de 4 caractères. | D'où provient le message d'erreur ?                      |

Quelques améliorations possibles pour une meilleure expérience utilisateur :

1. Certains messages provenant de l'API REST pourraient être gérés côté client. Ceci amène une incohérence dans l'expérience utilisateur. Idéalement, il faut faire le plus possible de la validation côté client pour éviter de faire des requêtes inutiles au serveur. Voir "sécurité : Validation coté client ou serveur ?" dans les notes de cours.
2. Certains messages sont en anglais et d'autres en français. Ce n'est pas une bonne pratique. Il faudrait tout mettre en français. Voir le commentaire à ce sujet dans le fichier `parseAxiosError.js`.
3. Ajouter des indicateurs de chargement lorsqu'une requête est en cours.
4. Le rafraîchissement de jeton, en cas d'expiration, n'a pas été implémenté. Voir le commentaire à ce sujet dans la méthode `refreshToken` de `authStore.js`.

### S'authentifier

À partir de la page connexion...

| Action                                                         | Comportement                                          |
| -------------------------------------------------------------- | ----------------------------------------------------- |
| Se connecter avec un courriel valide et un mot de passe valide | l'utilisateur est redirigé vers la page profile.      |
| Revenir en arrière                                             | l'utilisateur est redirigé vers la page de connexion. |
| Recharger la page                                              | l'utilisateur reste connecté.                         |
| Fermer et ouvrir le navigateur                                 | l'utilisateur reste connecté.                         |
| Ouvrir une autre fenêtre du navigateur                         | l'utilisateur reste connecté.                         |
| Essayer d'accéder à la page de connexion (/login)              | l'utilisateur est redirigé vers la page d'accueil.    |
| Se déconnecter                                                 | l'utilisateur est redirigé vers la page de connexion  |

---
Copyright © Exemple développé par Yannick Mazières et modifié par Jimmy Gilbert
