import setText, { appendText, showWaiting, hideWaiting } from './results.mjs'

// Les promesses (promises) permettent de faciliter l'écriture des fonctionnalités asynchrones.
// https://developer.mozilla.org/fr/docs/Web/JavaScript/Reference/Objets_globaux/Promise
//
// Trois états possibles pour une promesse
//  1. pending (attente)
//  2. fulfilled (succès)
//  3. rejected (erreur)
//  not pending (fulfilled ou rejected) = settled ou resolved
//
// Axio est une abstraction de XMLHttpRequest (voir header de consuming.html)
// https://github.com/axios/axios
// Avec axios, les états sont:
//  1. pending (attente)  ==> get
//  2. fulfilled (succès) ==> then
//  3. rejected (erreur)  ==> catch

export function get () {
  axios
    .get('http://localhost:3000/orders/1')
    .then(({ data }) => setText(JSON.stringify(data)))
}

export function getCatch () {
  axios
    .get('http://localhost:3000/orders/123')
    .then(({ data }) => {
      return setText(data.id)
    })
    .catch(err => {
      return setText(err)
    })
}

export function chain () {
  axios
    .get('http://localhost:3000/orders/1')
    .then(({ data }) => {
      return axios.get(
        `http://localhost:3000/addresses/${data.shippingAddress}`
      )
    })
    .then(({ data }) => {
      setText(`City: ${data.city}`)
    })
}

export function chainCatch () {
  axios
    .get('http://localhost:3000/orders/1')
    .then(({ data }) => {
      axios.get(`http://localhost:3000/addresses/${data.shippingAddress}`)
      throw new Error('Fake Error')
    })
    .then(({ data }) => {
      setText(`City: ${data.city}`)
    })
    .catch(err => {
      return setText(err)
    })
}

export function final () {
  showWaiting()
  axios
    .get('http://localhost:3000/orders/1')
    .then(({ data }) => {
      return axios.get(
        `http://localhost:3000/addresses/${data.shippingAddress}`
      )
    })
    .then(({ data }) => {
      setText(`City: ${data.city}`)
    })
    .catch(err => {
      return setText(err)
    })
    .finally(() => {
      setTimeout(() => {
        hideWaiting()
      }, 1500)
      appendText(' -- COMPLETELY DONE')
    })
}
