import setText, { appendText } from './results.mjs'

// Une promesse est un objet. Ex.:
//
//                        let myPromise = new Promise( (resolve, reject)  => { ... } )
//                                                         ^        ^           ^
// Fonction à appeler si le code asynchrone est un succès__|        |           |
// Fonction à appeler si le code asynchrone est en erreur___________|           |
// Code asynchrone à exécuter___________________________________________________|

export function timeout () {
  let wait = new Promise(resolve => {
    // Code asynchrone à exécuter
    setTimeout(() => {
      resolve(() => 'Timeout!') // callback si code asynchrone est un succès
    }, 1500)
  })

  wait.then(data => setText(data))
}

export function xhr () {
  let request = new Promise((resolve, reject) => {
    var xhr = new XMLHttpRequest()
    xhr.open('GET', 'http://localhost:3000/users/99')
    xhr.onload = () => {
      if (xhr.status === 200) {
        resolve(xhr.responseText)
      } else {
        reject(xhr.statusText)
      }
    }
    xhr.onerror = () => {
      reject('Request failed!')
    }
    xhr.send()
  })

  //request.then(setText).catch(setText)
  request.then(data => setText(data)).catch(err => setText(err))
}

// *************************************************************
// Pour ceux qui veulent aller plus loin...
// *************************************************************

// Promise.all
// Permet d'exécuter plusieurs fonctions asynchrones, sans dépendances entre elles,
// mais doit attendre que toutes soient terminées avant de poursuivre.
// Le "then" contient un array de resolve.
// S'il y'a une seule erreur, c'est le catch qui est executé.
export function allPromises () {
  let categories = axios.get('http://localhost:3000/itemCategories')
  let statuses = axios.get('http://localhost:3000/orderStatuses')
  let userTypes = axios.get('http://localhost:3000/userTypes')

  Promise.all([categories, statuses, userTypes])
    .then(([cat, stat, type]) => {
      setText('')
      appendText(JSON.stringify(cat.data))
      appendText(JSON.stringify(stat.data))
      appendText(JSON.stringify(type.data))
    })
    .catch(reasons => {
      setText(reasons)
    })
}

// Promise.allSettled
// Permet d'exécuter plusieurs fonctions asynchrones, sans dépendances entre elles.
// Le résultat de chacune des requêtes ainsi que l'état (fulfilled ou rejected) est
// stocké dans la réponse.
export function allSettled () {
  let categories = axios.get('http://localhost:3000/itemCategories')
  let statuses = axios.get('http://localhost:3000/orderStatuses')
  let userTypes = axios.get('http://localhost:3000/userTypes')
  let address = axios.get('http://localhost:3000/addressTypes') // N'existe pas !

  Promise.allSettled([categories, statuses, userTypes, address])
    .then(values => {
      let results = values.map(v => {
        if (v.status === 'fulfilled') {
          return `FULFILLED: ${JSON.stringify(v.value.data[0])}`
        }

        return `REJECTED: ${v.reason.message}`
      })

      setText(results)
    })
    .catch(reasons => {
      setText(reasons)
    })
}

// Promise.race
// Si plusieurs "endpoint", choisit le plus rapide.
// Essayer avec deux serveurs (npm run dev secondary)

export function race () {
  let users = axios.get('http://localhost:3000/users')
  let backupUsers = axios.get('http://localhost:3001/users')
  Promise.race([users, backupUsers])
    .then(users => setText(JSON.stringify(users.data)))
    .catch(reason => setText(reason))
}
