import toastr from 'toastr'
import DogService from '../services/dogsService'

export default class DogsComponent {
  constructor () {
    this.dogs = []
    this.apiService = new DogService()
  }

  async initialize (componentEl) {
    componentEl.innerHTML = `
      <h2>Une liste de noms de chien</h2>
      <P> Un clic sur un item de la liste affiche dans la console le id du chien et la race du chien. <p>
      <img src="./images/loading-waiting.gif" alt="Chargement..." width="20" />
      <ul></ul>
    `
    this.dogsListEl = componentEl.querySelector('ul')
    this.loadingEl = componentEl.querySelector('img')
    this.hideLoading()

    await this.renderComponent()
  }

  async renderComponent () {
    try {
      this.showLoading()
      this.dogs = await this.apiService.getDogs()
      this.dogs.forEach(dog => {
        this.createListItem(dog)
      })
    } catch (error) {
      this.displayErrorMessage(error)
    } finally {
      this.hideLoading()
    }
  }

  createListItem (dog) {
    const listItemEl = document.createElement('li')
    listItemEl.innerHTML = dog.name
    // voir https://www.w3schools.com/tags/att_global_data.asp pour l'utilisation
    // de l'attribut "data-*" ____
    //                            V
    listItemEl.setAttribute('data-dog-id', dog.id)
    listItemEl.addEventListener('click', event =>
      this.logDogIdAndBreed(event.currentTarget)
    )
    this.dogsListEl.appendChild(listItemEl)
  }

  async logDogIdAndBreed (listItemEl) {
    try {
      this.showLoading()
      const dogId = listItemEl.getAttribute('data-dog-id')
      const dog = await this.apiService.getDog(dogId)
      console.log('Id du chien cliqué: ', dog.id, ' Race: ', dog.breed.name)
    } catch (error) {
      this.displayErrorMessage(error)
    } finally {
      this.hideLoading()
    }
  }

  showLoading () {
    this.loadingEl.style.visibility = 'visible'
    // this.loadingEl.style.display = 'inline'
  }
  hideLoading () {
    this.loadingEl.style.visibility = 'hidden'
    // this.loadingEl.style.display = 'none'
  }

  displayErrorMessage (error) {
    console.log('*** ' + error)

    toastr.options = {
      closeButton: true,
      timeOut: '0'
    }
    toastr.error(
      "Une erreur est survenue sur cette page. Si l'erreur persiste, communiquez avec le service à la clientèle."
    )
  }
}
