// @vitest-environment jsdom
import {
  describe,
  test,
  expect,
  afterAll,
  afterEach,
  beforeAll,
  beforeEach,
  vi
} from 'vitest'
import toastr from 'toastr'
import flushPromises from 'flush-promises'
import { setupServer } from 'msw/node'
import { success, failureDogs, failureDog } from '../tests/mocks/handlers'
import DogsComponent from '../src/components/dogsComponent'
import { dogs } from './data/dogs.js'

let componentEl
const server = setupServer(...success)

beforeAll(() => server.listen({ onUnhandledRequest: 'error' }))
afterAll(() => server.close())
afterEach(() => server.resetHandlers())
beforeEach(() => {
  document.querySelector('html').innerHTML = ''
  componentEl = document.createElement('div')
  document.body.appendChild(componentEl)
})

describe('dogsComponent.js', () => {
  describe('success', () => {
    test("À l'ouverture, la liste doit contenir les noms des chiens", async () => {
      const dogsComponent = new DogsComponent()
      const expectedDogs = dogs.map(dog => dog.name)

      await dogsComponent.initialize(componentEl)

      const liEls = Array.from(document.getElementsByTagName('li'))
      const resultDogs = liEls.map(dogEl => dogEl.innerHTML)
      expect(resultDogs).toEqual(expectedDogs)
    })

    test.skip('Sur le clic du premier élément de la liste, le id du chien et la race sont affichés dans la console du navigateur.', async () => {})
    // TEST À FAIRE
  })

  describe('failure', () => {
    test("Un message doit informer l'utilisateur si l'api n'est pas joignable lors de la récupération de tous les chiens.", async () => {
      server.use(...failureDogs)
      const toastrSpy = vi.spyOn(toastr, 'error')
      const dogsComponent = new DogsComponent()

      await dogsComponent.initialize(componentEl)

      expect(toastrSpy).toHaveBeenCalled()
    })

    test.skip("Un message doit informer l'utilisateur si l'api n'est pas joignable lors de la récupération d'un chien", async () => {
      // TEST À FAIRE
    })
  })
})
