import { describe, expect, it } from 'vitest'
import { mount } from '@vue/test-utils'
import TodoAdder from '../TodoAdder.vue'

describe('TodoAdder.vue', () => {

  it("Par défaut, la zone d'ajout est vide.", async () => {
    const wrapper = mount(TodoAdder)
    //const taskInputEl = wrapper.find('input[type="text"]').element as HTMLInputElement
    //selecteur sur ID id="task" mieyx que juste le type text et input
    const taskInputEl = wrapper.find('#task').element as HTMLInputElement

    expect(taskInputEl.value).toBe('')
  })

  it("Par défaut, aucun bouton d'ajout n'est affiché.", () => {
    const wrapper = mount(TodoAdder)
    const buttonEl = wrapper.find('button') // Utilise le bon sélecteur pour ton bouton

    expect(buttonEl.exists()).toBe(false)
  })

  it("Sur le clic du bouton, doit émettre l'événement 'newtask'", async () => {
    const wrapper = mount(TodoAdder)
    const taskInputEl = wrapper.find('input[type="text"]') // Assure-toi que l'input a le bon sélecteur
    const task = 'tache 1'

    await taskInputEl.setValue(task)
    await wrapper.find('button').trigger('click') // Assure-toi que le bouton a le bon sélecteur

    expect(wrapper.emitted('newtask')![0]).toEqual([task])
  })

  it("Après avoir ajouté une tâche, la zone d'ajout est vidée.", async () => {
    const wrapper = mount(TodoAdder)
    const taskInput = wrapper.find('input[type="text"]')
    const taskInputEl = taskInput.element as HTMLInputElement
    const taskToAdd = 'any task'

    await taskInput.setValue(taskToAdd)
    await wrapper.find('button').trigger('click') // Assure-toi que le bouton a le bon sélecteur

    expect(taskInputEl.value).toBe('')
  })
})
